<style>
    .dt tr td {
        border: 0px;
        padding: 2px !important;
    }
</style>
<table class="table table-sm dt">
    <tr>
        <td width="12%">No. Transaksi</td>
        <td>: {{ $t->kd_transaksi }}</td>
        <td width="27%"></td>
        <td>Tanggal</td>
        <td>: {{ tgl_inf($t->created_at) }}</td>
    </tr>
    <tr>
        <td>A. Nama</td>
        <td>: {{ $t->member->nm_member }} - HP : <span class="text-blue"> {{ $t->member->hp_member }} </span> - Email :
            <span class="text-blue"> {{ $t->member->email_member }} </span>
        </td>
        <td></td>
        <td>Petugas</td>
        <td>: {{ $t->user->nm_user }}</td>
    </tr>
    <tr>
        <td>Status Order</td>
        <td>: {!! $t->jns_transaksi == 'OFF'
            ? ' <span class="text-danger">Offline</span>'
            : ' <span class="text-primary">Online</span>' !!}</td>
        <td></td>
        <td>Sts. Antar</td>
        <td>: {{ $t->sts_antar == 'Y' ? 'Diantar' : 'Ambil ditoko' }}</td>
    </tr>
</table>
<table class="table table-sm table-bordered table-striped tab">
    <thead>
        <tr class="bg-danger">
            <td colspan="10" class="text-center">DATA ORDER</td>
        </tr>
        <tr>
            <th width="3%"> No</th>
            <th>Item</th>
            <th>Harga</th>
            <th>Disc</th>
            <th>Qty</th>
            <th>Jumlah</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($t->keranjang()->get() as $k)
            <tr>
                <td class="text-center">{{ $no++ }}</td>
                <td>{{ $k->produk->nm_produk }}</td>
                <td class="text-right">{{ number_format($k->harga, 0, ',', '.') }},-</td>
                <td class="text-center">{{ number_format($k->diskon, 0, ',', '.') }}%</td>
                <td class="text-center">{{ number_format($k->jumlah, 0, ',', '.') }}</td>
                <td class="text-right">
                    {{ number_format(($k->harga - ($k->harga * $k->diskon) / 100) * $k->jumlah, 0, ',', '.') }},-</td>
            </tr>
        @endforeach
        <tr>
            <td colspan="10">
                <br>
            </td>
        </tr>
        <tr style="font-weight: bold; text-align: right; font-size: 18px; padding-top: 5px;">
            <td colspan="4"></td>
            <td>Subtotal</td>
            <td>{{ number_format($t->jumlah, 0, ',', '.') }},-</td>
        </tr>
        <tr style="font-weight: bold; text-align: right; font-size: 18px;">
            <td colspan="4"></td>
            <td>Ongkir</td>
            <td>{{ number_format($t->ongkir, 0, ',', '.') }},-</td>
        </tr>
        <tr style="font-weight: bold; text-align: right; font-size: 18px;">
            <td colspan="4"></td>
            <td>Diskon</td>
            <td>{{ number_format($t->diskon, 0, ',', '.') }}%</td>
        </tr>
        <tr style="font-weight: bold; text-align: right; font-size: 18px;">
            <td colspan="4"></td>
            <td>Grand Total</td>
            <td>{{ number_format($t->total, 0, ',', '.') }},-</td>
        </tr>
        <tr style="font-weight: bold; text-align: right; font-size: 18px;">
            <td colspan="4"></td>
            <td>Dibayar</td>
            <td>{{ number_format($t->dibayar, 0, ',', '.') }},-</td>
        </tr>
        <tr style="font-weight: bold; text-align: right; font-size: 18px;">
            <td colspan="4"></td>
            <td>Kembali</td>
            <td>{{ number_format($t->dibayar - $t->total, 0, ',', '.') }},-</td>
        </tr>
    </tbody>
</table>
<table class="table table-sm dt">
    <tr>
        <td>Pembayaran</td>
        <td>:</td>
        <td>{{ $t->via_bayar == 'T' ? 'Transfer' : 'Cash' }}</td>
    </tr>
    <tr>
        <td width="12%">Jml. Poin</td>
        <td width="1%">:</td>
        <td>{{ poinbaru($t->kd_transaksi) }}</td>
    </tr>
    <tr>
        <td>Kurir</td>
        <td>:</td>
        <td>
            @if ($t->kurir == null)
                -
            @else
                {{ $t->kurir->karyawan->nm_karyawan }}
            @endif
        </td>
    </tr>
    <tr>
        <td>Tgl. Diantar</td>
        <td>:</td>
        <td>
            @if ($t->kurir == null)
                -
            @else
                {{ tgl_inf($t->kurir->created_at) }}
            @endif
        </td>
    </tr>
    <tr>
        <td>Tgl. Diterima</td>
        <td>:</td>
        <td>
            @empty($t->pembayaran)
                -
            @else
                @if ($t->pembayaran->tgl_diterima == null)
                    -
                @else
                    {{ tgl_inf($t->pembayaran->tgl_diterima) }}
                @endif
            @endempty

        </td>
    </tr>
</table>
